<?php
session_start();
define('IS_ADMIN','true');
require('../core/config/config.php');
require('../core/config/config-theme.php');
require('../core/config/config-ads.php');
require('../core/system.php');

if(!isLogged() || $user['is_admin'] == 0) { header('Location: ../index.php'); exit; }

$page['name'] = 'Admin - User Generator';
$menu['generator'] = 'active';

if(isset($_POST['generate'])) {
	$nationality = $_POST['nationality'];
	$gender = $_POST['gender'];
	$info = url_get_contents('http://condor5.com/api/cu.php?gender='.$gender.'&nationality='.$nationality.'');
	$info = json_decode($info,true);
	foreach($info as $array => $arr) {
		$country = getCountryNameByCode($nationality);
		foreach($arr as $a) {   
			$gender = ucfirst($a['user']['gender']);
			$first_name = ucfirst($a['user']['name']['first']);
			$last_name = ucfirst($a['user']['name']['last']);
			$full_name = $first_name.' '.$last_name;
			$email = $a['user']['email'];
			if($nationality == 'DE') {
				$cities = array('Berlin','Hamburg','Minich','Cologne','Frankfurt','Stuttgart','Dortmund','Essen','Bremen','Hanover','Bonn','Aachen','Bochum','Wuppertal','Mannheim');
				$city = $cities[array_rand($cities)];
			} elseif($nationality == 'AR') {
				$cities = array('Buenos Aires','Córdoba','Rosario','Mendoza','Santa Fe','Salta','San Juan','Resistencia','La Plata','Avellaneda','Corrientes','Concordia','Lanús');
				$city = $cities[array_rand($cities)];
			} else {
			$city = ucfirst($a['user']['location']['city']);
			}
			$time = time();
			$profile_picture = $a['user']['picture']['large'];
			$age = mt_rand(20,45);
			$db->query("INSERT INTO users(profile_picture,full_name,email,password,registered,country,city,energy,age,gender,ip,latitude,longitude,local_range) VALUES ('$profile_picture','$full_name','$email','"._hash('123456')."','$time','$country','$city','10','$age','$gender','','60','45','0,150')");
		}
	}
	$success = true;
}

require('../inc/admin/top.php');
?>
<section>
<div class="content-wrapper">
<div class="container-fluid">
<div class="row">
<div class="col-md-12">
<form action="" method="post">
<div class="panel panel-default">
<div class="panel-heading panel-title"> User Generator </div>
<div class="panel-body">
<?php if(isset($success)) { ?> <div class="alert alert-success"> <i class="fa fa-check fa-fw"></i> 100 users have been generated succesfully </div> <?php } ?>
A dating website without users is not a dating website. <br> This tool will generate up to 100 unique users, to give your website a solid start. <br><br>
<select name="nationality" class="form-control" required>
<option value="" disabled selected>Country</option>
<option value="AU"> Australia </option>
<option value="AR"> Argentina </option>
<option value="IE"> Ireland </option>
<option value="FI"> Finland </option>
<option value="FR"> France </option>
<option value="DE"> Germany </option>
<option value="US"> United States </option>
<option value="GB"> United Kingdom </option>
<option value="ES"> Spain </option>
<option value="NL"> Netherlands </option>
</select>
<br>
<select name="gender" class="form-control">
<option value="" disabled selected>Gender</option>
<option value="all"> All </option>
<option value="male"> Male </option>
<option value="female"> Female </option>
</select>
<br>
<input type="submit" name="generate" class="btn btn-danger" value="Generate">
</div>
</form>
</div>
</div>
</div>
</div>
</section>
<script src="<?php echo $domain?>/vendor/modernizr/modernizr.js"></script>
<script src="<?php echo $domain?>/vendor/jquery/dist/jquery.js"></script>
<script src="<?php echo $domain?>/vendor/bootstrap/dist/js/bootstrap.js"></script>
<script src="<?php echo $domain?>/vendor/jQuery-Storage-API/jquery.storageapi.js"></script>
<script src="<?php echo $domain?>/vendor/animo.js/animo.js"></script>
<script src="<?php echo $domain?>/vendor/sweetalert/dist/sweetalert.min.js"></script>
<script src="<?php echo $domain?>/app/js/app.js"></script>
</body>
</html>